function [apstime, dbins, sizedist, binwidth] = hiscale_APSimport()



cd('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\APS - Aerodynamic Particle Sizer - S01');
currdir = dir;
apstime = [];

sizedist = [];
dbounds = [];

for i = 1:length(currdir)
	currfile = currdir(i).name;
	
	cdfcheck = contains(currfile,'.cdf') || contains(currfile,'.nc');
	if cdfcheck == 0
		continue
	end
	
	apstime = [apstime ; ARMtimeimport(currfile,17)];
	
	sizedist = [sizedist , ncread(currfile,'N_TOF')];
	
	dbounds = ncread(currfile,'aerodynamic_diameter_bound');
	
end

binwidth = dbounds(2,:) - dbounds(1,:);

dbins = mean(dbounds',2);